<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>

<!-- Modern Hero Section - Side by Side Layout -->
<div class="hero-section position-relative overflow-hidden" style="min-height: 100vh; display: flex; align-items: center; background: linear-gradient(135deg, #F0F8FF 0%, #E6F3FF 50%, #DBEAFE 100%);">
    
    <div class="container position-relative" style="z-index: 2;">
        <div class="row align-items-center min-vh-100 g-0">
            <!-- Left Side - Profile Image -->
            <div class="col-lg-5">
                <div class="profile-section text-center position-relative">
                    <!-- Decorative Background Circle -->
                    <div class="profile-bg-circle position-absolute" style="
                        width: 400px; 
                        height: 400px; 
                        background: linear-gradient(135deg, rgba(135, 206, 235, 0.2), rgba(65, 105, 225, 0.2)); 
                        border-radius: 50%; 
                        top: 50%; 
                        left: 50%; 
                        transform: translate(-50%, -50%); 
                        z-index: -1;
                    "></div>
                    
                    <?php if ($biodata && isset($biodata['foto_profil']) && $biodata['foto_profil']): ?>
                        <div class="profile-image-wrapper position-relative d-inline-block">
                            <img src="<?= image_url('biodata', $biodata['foto_profil'], 350, 350) ?>" 
                                 class="img-fluid rounded-circle profile-image-static" 
                                 alt="Profile"
                                 onerror="this.src='<?= base_url('placeholder/350/350') ?>'; this.onerror=null;"
                                 style="
                                    width: 350px; 
                                    height: 350px; 
                                    object-fit: cover;
                                    border: 6px solid #FFFFFF; 
                                    box-shadow: 0 20px 60px rgba(65, 105, 225, 0.3);
                                    transition: transform 0.3s ease;
                                 "
                                 onmouseover="this.style.transform='scale(1.05)'"
                                 onmouseout="this.style.transform='scale(1)'">
                            
                            <!-- Floating Status Badge -->
                            <div class="status-badge position-absolute" style="
                                bottom: 20px; 
                                right: 20px; 
                                background: linear-gradient(135deg, #87CEEB, #4169E1); 
                                color: white; 
                                padding: 8px 16px; 
                                border-radius: 25px; 
                                font-size: 0.9rem; 
                                font-weight: 600;
                                box-shadow: 0 4px 15px rgba(65, 105, 225, 0.3);
                            ">
                                <i class="bi bi-circle-fill me-1" style="font-size: 0.6rem; color: #90EE90;"></i>
                                Available
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="profile-placeholder d-inline-flex align-items-center justify-content-center rounded-circle" 
                             style="
                                width: 350px; 
                                height: 350px; 
                                background: linear-gradient(135deg, #87CEEB, #4169E1); 
                                border: 6px solid #FFFFFF;
                                box-shadow: 0 20px 60px rgba(65, 105, 225, 0.3);
                             ">
                            <i class="bi bi-person-circle" style="font-size: 8rem; color: white;"></i>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            
            <!-- Right Side - Content -->
            <div class="col-lg-7 ps-lg-5">
                <div class="content-section">
                    <?php if ($biodata && isset($biodata['nama_lengkap'])): ?>
                        <!-- Welcome Badge -->
                        <div class="welcome-badge d-inline-block mb-4" style="
                            background: rgba(255, 255, 255, 0.9); 
                            border: 1px solid rgba(135, 206, 235, 0.3); 
                            border-radius: 50px; 
                            padding: 12px 24px;
                            box-shadow: 0 4px 15px rgba(65, 105, 225, 0.1);
                        ">
                            <i class="bi bi-stars me-2" style="color: #4169E1;"></i>
                            <span style="color: #1E3A8A; font-weight: 600;">Selamat Datang di Portofolio Saya</span>
                        </div>
                        
                        <!-- Main Title -->
                        <h1 class="display-4 fw-bold mb-4" style="
                            color: #1E3A8A; 
                            line-height: 1.2;
                            background: linear-gradient(135deg, #1E3A8A 0%, #4169E1 50%, #87CEEB 100%);
                            -webkit-background-clip: text;
                            -webkit-text-fill-color: transparent;
                            background-clip: text;
                        ">
                            Hi, I'm<br>
                            <span style="font-size: 1.2em;"><?= esc($biodata['nama_lengkap']) ?></span>
                        </h1>
                        
                        <?php if ($biodata['nama_panggilan']): ?>
                            <div class="nickname-section mb-4" style="
                                background: rgba(135, 206, 235, 0.1); 
                                border-left: 4px solid #4169E1; 
                                padding: 16px 20px; 
                                border-radius: 0 12px 12px 0;
                            ">
                                <p class="mb-0" style="color: #1E3A8A; font-size: 1.2rem; font-style: italic;">
                                    <i class="bi bi-quote me-2" style="color: #4169E1;"></i>
                                    "<?= esc($biodata['nama_panggilan']) ?>"
                                </p>
                            </div>
                        <?php endif; ?>
                        
                        <?php if ($biodata['tentang_saya']): ?>
                            <div class="about-section mb-5">
                                <p style="
                                    color: #1E3A8A; 
                                    font-size: 1.1rem; 
                                    line-height: 1.8; 
                                    margin-bottom: 0;
                                ">
                                    <?= esc($biodata['tentang_saya']) ?>
                                </p>
                            </div>
                        <?php endif; ?>
                        
                        <!-- Action Buttons -->
                        <div class="action-buttons d-flex flex-wrap gap-3 mb-5">
                            <?php if ($biodata['email']): ?>
                                <a href="mailto:<?= esc($biodata['email']) ?>" class="btn-custom btn-primary">
                                    <i class="bi bi-envelope-fill me-2"></i>Get In Touch
                                </a>
                            <?php endif; ?>
                            <a href="<?= base_url('biodata') ?>" class="btn-custom btn-outline">
                                <i class="bi bi-person-fill me-2"></i>Lihat Profil Lengkap
                            </a>
                            <?php if ($biodata['linkedin']): ?>
                                <a href="<?= esc($biodata['linkedin']) ?>" target="_blank" class="btn-custom btn-social">
                                    <i class="bi bi-linkedin me-2"></i>LinkedIn
                                </a>
                            <?php endif; ?>
                        </div>
                        
                        <!-- Quick Stats -->
                        <div class="quick-stats row g-3">
                            <div class="col-4">
                                <div class="stat-card text-center" style="
                                    background: rgba(255, 255, 255, 0.8); 
                                    border: 1px solid rgba(135, 206, 235, 0.3); 
                                    border-radius: 16px; 
                                    padding: 20px 10px;
                                    box-shadow: 0 4px 15px rgba(65, 105, 225, 0.1);
                                ">
                                    <i class="bi bi-calendar-event" style="font-size: 2rem; color: #4169E1;"></i>
                                    <div style="color: #1E3A8A; font-weight: 600; margin-top: 8px;">Activities</div>
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="stat-card text-center" style="
                                    background: rgba(255, 255, 255, 0.8); 
                                    border: 1px solid rgba(135, 206, 235, 0.3); 
                                    border-radius: 16px; 
                                    padding: 20px 10px;
                                    box-shadow: 0 4px 15px rgba(65, 105, 225, 0.1);
                                ">
                                    <i class="bi bi-award" style="font-size: 2rem; color: #4169E1;"></i>
                                    <div style="color: #1E3A8A; font-weight: 600; margin-top: 8px;">Certificates</div>
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="stat-card text-center" style="
                                    background: rgba(255, 255, 255, 0.8); 
                                    border: 1px solid rgba(135, 206, 235, 0.3); 
                                    border-radius: 16px; 
                                    padding: 20px 10px;
                                    box-shadow: 0 4px 15px rgba(65, 105, 225, 0.1);
                                ">
                                    <i class="bi bi-folder" style="font-size: 2rem; color: #4169E1;"></i>
                                    <div style="color: #1E3A8A; font-weight: 600; margin-top: 8px;">Proyek</div>
                                </div>
                            </div>
                        </div>
                        
                    <?php else: ?>
                        <!-- Default Content -->
                        <div class="welcome-badge d-inline-block mb-4" style="
                            background: rgba(255, 255, 255, 0.9); 
                            border: 1px solid rgba(135, 206, 235, 0.3); 
                            border-radius: 50px; 
                            padding: 12px 24px;
                        ">
                            <i class="bi bi-stars me-2" style="color: #4169E1;"></i>
                            <span style="color: #1E3A8A; font-weight: 600;">Selamat Datang</span>
                        </div>
                        
                        <h1 class="display-4 fw-bold mb-4" style="color: #1E3A8A;">
                            Selamat Datang<br>
                            <span style="color: #4169E1;">di Portofolio</span>
                        </h1>
                        
                        <p style="color: #1E3A8A; font-size: 1.2rem; line-height: 1.8; margin-bottom: 2rem;">
                            Website portofolio profesional dengan fitur lengkap dan desain modern
                        </p>
                        
                        <div class="action-buttons d-flex flex-wrap gap-3">
                            <a href="<?= base_url('biodata') ?>" class="btn-custom btn-primary">
                                <i class="bi bi-person-fill me-2"></i>Lihat Biodata
                            </a>
                            <a href="<?= base_url('projects') ?>" class="btn-custom btn-outline">
                                <i class="bi bi-folder-fill me-2"></i>Lihat Proyek
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Custom Button Styles -->
<style>
.btn-custom {
    padding: 12px 28px;
    border-radius: 50px;
    font-weight: 600;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    transition: all 0.3s ease;
    border: 2px solid transparent;
}

.btn-primary {
    background: linear-gradient(135deg, #87CEEB 0%, #4169E1 100%);
    color: white;
    box-shadow: 0 4px 15px rgba(65, 105, 225, 0.3);
}

.btn-primary:hover {
    background: linear-gradient(135deg, #4169E1 0%, #87CEEB 100%);
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(65, 105, 225, 0.4);
    color: white;
}

.btn-outline {
    background: rgba(255, 255, 255, 0.9);
    color: #1E3A8A;
    border: 2px solid rgba(135, 206, 235, 0.5);
}

.btn-outline:hover {
    background: rgba(65, 105, 225, 0.1);
    border-color: #4169E1;
    color: #4169E1;
    transform: translateY(-2px);
}

.btn-social {
    background: rgba(135, 206, 235, 0.2);
    color: #1E3A8A;
    border: 2px solid rgba(135, 206, 235, 0.3);
}

.btn-social:hover {
    background: #4169E1;
    color: white;
    border-color: #4169E1;
    transform: translateY(-2px);
}

.stat-card {
    transition: all 0.3s ease;
}

.stat-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 25px rgba(65, 105, 225, 0.2) !important;
}

/* Mobile Responsive */
@media (max-width: 991px) {
    .hero-section .row {
        text-align: center;
    }
    
    .col-lg-5 {
        margin-bottom: 3rem;
    }
    
    .profile-image-static {
        width: 280px !important;
        height: 280px !important;
    }
    
    .profile-bg-circle {
        width: 320px !important;
        height: 320px !important;
    }
    
    .display-4 {
        font-size: 2.5rem;
    }
}

@media (max-width: 576px) {
    .profile-image-static {
        width: 220px !important;
        height: 220px !important;
    }
    
    .profile-bg-circle {
        width: 260px !important;
        height: 260px !important;
    }
    
    .btn-custom {
        padding: 10px 20px;
        font-size: 0.9rem;
    }
    
    .quick-stats .col-4 {
        margin-bottom: 1rem;
    }
}
</style>

<!-- Recent Activities Section -->
<?php if (!empty($recentActivities)): ?>
<div class="activities-section py-5" style="background: rgba(240, 248, 255, 0.5);">
    <div class="container py-5">
        <div class="section-header text-center mb-5">
            <h2 class="section-title" style="
                color: #1E3A8A; 
                font-size: 2.5rem; 
                font-weight: 700; 
                margin-bottom: 1rem;
            ">
                <i class="bi bi-calendar-event me-3" style="color: #4169E1;"></i>
                Latest Activities
            </h2>
            <p style="color: #1E3A8A; font-size: 1.1rem;">Temukan proyek dan pencapaian terbaru saya</p>
        </div>
        
        <div class="row g-4">
            <?php foreach ($recentActivities as $activity): ?>
                <div class="col-lg-4 col-md-6">
                    <div class="activity-card" style="
                        background: rgba(255, 255, 255, 0.9); 
                        border: 1px solid rgba(135, 206, 235, 0.3); 
                        border-radius: 20px; 
                        overflow: hidden;
                        box-shadow: 0 8px 25px rgba(65, 105, 225, 0.1);
                        transition: all 0.3s ease;
                        height: 100%;
                    " onmouseover="this.style.transform='translateY(-10px)'; this.style.boxShadow='0 15px 35px rgba(65, 105, 225, 0.2)'" 
                       onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='0 8px 25px rgba(65, 105, 225, 0.1)'">
                        
                        <?php if ($activity['foto']): ?>
                            <div class="activity-image" style="height: 200px; overflow: hidden;">
                                <img src="<?= image_url('activities', $activity['foto'], 400, 200) ?>" 
                                     class="w-100 h-100" alt="<?= esc($activity['nama_aktivitas']) ?>"
                                     style="object-fit: cover; transition: transform 0.3s ease;"
                                     onerror="this.src='<?= base_url('placeholder/400/200') ?>'; this.onerror=null;"
                                     onmouseover="this.style.transform='scale(1.1)'"
                                     onmouseout="this.style.transform='scale(1)'">
                            </div>
                        <?php else: ?>
                            <div class="activity-placeholder d-flex align-items-center justify-content-center" 
                                 style="height: 200px; background: linear-gradient(135deg, #87CEEB, #4169E1);">
                                <i class="bi bi-image text-white" style="font-size: 3rem;"></i>
                            </div>
                        <?php endif; ?>
                        
                        <div class="activity-content p-4">
                            <h5 style="color: #1E3A8A; font-weight: 600; margin-bottom: 1rem;">
                                <?= esc($activity['nama_aktivitas']) ?>
                            </h5>
                            
                            <div class="activity-meta mb-3">
                                <div class="d-flex align-items-center mb-2">
                                    <i class="bi bi-calendar3 me-2" style="color: #4169E1;"></i>
                                    <span style="color: #1E3A8A; font-size: 0.9rem;">
                                        <?= date('d F Y', strtotime($activity['tanggal'])) ?>
                                    </span>
                                </div>
                                <div class="d-flex align-items-center">
                                    <i class="bi bi-clock me-2" style="color: #4169E1;"></i>
                                    <span style="color: #1E3A8A; font-size: 0.9rem;">
                                        <?= date('H:i', strtotime($activity['jam'])) ?>
                                    </span>
                                </div>
                            </div>
                            
                            <?php if ($activity['deskripsi']): ?>
                                <p style="color: #1E3A8A; font-size: 0.95rem; line-height: 1.6;">
                                    <?= esc(substr($activity['deskripsi'], 0, 120)) ?><?= strlen($activity['deskripsi']) > 120 ? '...' : '' ?>
                                </p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        
        <div class="text-center mt-5">
            <a href="<?= base_url('activities') ?>" class="btn-custom btn-primary">
                Lihat Semua Aktivitas <i class="bi bi-arrow-right ms-2"></i>
            </a>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- Recent Certificates Section -->
<?php if (!empty($recentCertificates)): ?>
<div class="certificates-section py-5" style="background: rgba(255, 255, 255, 0.8);">
    <div class="container py-5">
        <div class="section-header text-center mb-5">
            <h2 class="section-title" style="
                color: #1E3A8A; 
                font-size: 2.5rem; 
                font-weight: 700; 
                margin-bottom: 1rem;
            ">
                <i class="bi bi-award me-3" style="color: #4169E1;"></i>
                Recent Certificates
            </h2>
            <p style="color: #1E3A8A; font-size: 1.1rem;">Professional certifications and achievements</p>
        </div>
        
        <div class="row g-4">
            <?php foreach ($recentCertificates as $cert): ?>
                <div class="col-lg-4 col-md-6">
                    <div class="certificate-card" style="
                        background: rgba(255, 255, 255, 0.9); 
                        border: 1px solid rgba(135, 206, 235, 0.3); 
                        border-radius: 20px; 
                        overflow: hidden;
                        box-shadow: 0 8px 25px rgba(65, 105, 225, 0.1);
                        transition: all 0.3s ease;
                        height: 100%;
                    " onmouseover="this.style.transform='translateY(-10px)'; this.style.boxShadow='0 15px 35px rgba(65, 105, 225, 0.2)'" 
                       onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='0 8px 25px rgba(65, 105, 225, 0.1)'">
                        
                        <?php if (isset($cert['foto_sertifikat']) && $cert['foto_sertifikat']): ?>
                            <div class="certificate-image" style="height: 200px; overflow: hidden; position: relative;">
                                <img src="<?= image_url('certificates', $cert['foto_sertifikat'], 400, 200) ?>" 
                                     class="w-100 h-100" alt="<?= esc($cert['nama_sertifikat']) ?>"
                                     style="object-fit: cover; transition: transform 0.3s ease;"
                                     onerror="this.src='<?= base_url('placeholder/400/200') ?>'; this.onerror=null;"
                                     onmouseover="this.style.transform='scale(1.1)'"
                                     onmouseout="this.style.transform='scale(1)'">
                                <div class="certificate-overlay position-absolute top-0 start-0 w-100 h-100 d-flex align-items-center justify-content-center" 
                                     style="background: rgba(65, 105, 225, 0.8); opacity: 0; transition: opacity 0.3s ease;"
                                     onmouseover="this.style.opacity='1'"
                                     onmouseout="this.style.opacity='0'">
                                    <i class="bi bi-eye text-white" style="font-size: 2rem;"></i>
                                </div>
                            </div>
                        <?php else: ?>
                            <div class="certificate-placeholder d-flex align-items-center justify-content-center" 
                                 style="height: 200px; background: linear-gradient(135deg, #87CEEB, #4169E1);">
                                <i class="bi bi-award text-white" style="font-size: 3rem;"></i>
                            </div>
                        <?php endif; ?>
                        
                        <div class="certificate-content p-4">
                            <h5 style="color: #1E3A8A; font-weight: 600; margin-bottom: 1rem;">
                                <i class="bi bi-award-fill me-2" style="color: #FFD700;"></i>
                                <?= esc($cert['nama_sertifikat']) ?>
                            </h5>
                            
                            <div class="certificate-meta mb-3">
                                <?php if ($cert['penerbit']): ?>
                                    <div class="d-flex align-items-center mb-2">
                                        <i class="bi bi-building me-2" style="color: #4169E1;"></i>
                                        <span style="color: #1E3A8A; font-size: 0.9rem;">
                                            <?= esc($cert['penerbit']) ?>
                                        </span>
                                    </div>
                                <?php endif; ?>
                                
                                <?php if ($cert['tanggal_terbit']): ?>
                                    <div class="d-flex align-items-center mb-2">
                                        <i class="bi bi-calendar-check me-2" style="color: #4169E1;"></i>
                                        <span style="color: #1E3A8A; font-size: 0.9rem;">
                                            <?= date('d F Y', strtotime($cert['tanggal_terbit'])) ?>
                                        </span>
                                    </div>
                                <?php endif; ?>
                                
                                <?php if ($cert['nomor_sertifikat']): ?>
                                    <div class="d-flex align-items-center">
                                        <i class="bi bi-hash me-2" style="color: #4169E1;"></i>
                                        <span style="color: #1E3A8A; font-size: 0.85rem;">
                                            <?= esc($cert['nomor_sertifikat']) ?>
                                        </span>
                                    </div>
                                <?php endif; ?>
                            </div>
                            
                            <?php if ($cert['deskripsi']): ?>
                                <p style="color: #1E3A8A; font-size: 0.95rem; line-height: 1.6;">
                                    <?= esc(substr($cert['deskripsi'], 0, 100)) ?><?= strlen($cert['deskripsi']) > 100 ? '...' : '' ?>
                                </p>
                            <?php endif; ?>
                            
                            <div class="certificate-actions mt-3">
                                <?php if (isset($cert['link_sertifikat']) && $cert['link_sertifikat']): ?>
                                    <a href="<?= esc($cert['link_sertifikat']) ?>" target="_blank" 
                                       class="btn btn-sm me-2" style="
                                        background: rgba(135, 206, 235, 0.2); 
                                        color: #4169E1; 
                                        border: 1px solid rgba(135, 206, 235, 0.3); 
                                        border-radius: 20px;
                                        padding: 6px 16px;
                                       ">
                                        <i class="bi bi-link-45deg me-1"></i>Lihat
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        
        <div class="text-center mt-5">
            <a href="<?= base_url('certificates') ?>" class="btn-custom btn-primary">
                Lihat Semua Sertifikat <i class="bi bi-collection ms-2"></i>
            </a>
        </div>
    </div>
</div>
<?php endif; ?>

<?= $this->endSection() ?>

